/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.kintai.dao.MYukyuDao;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.dto.MYukyuDto;
import jp.mosp.kintai.vo.PaidHolidayCardVo;

import jp.mosp.payroll.dao.MKintaiDao;

public class PaidHolidayCardAction extends AttendanceTotalAction {

	// R}h
	private static final String CMD_YUKYU_PERSONAL_SHOW   	= "K1300";	// \

	/**
	 * RXgN^
	 */
	public PaidHolidayCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		PaidHolidayCardVo vo = new PaidHolidayCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBRlNV擾
		getConnection();
		// DTO̎擾
		MYukyuDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MYukyuDto ? (MYukyuDto)obj : null;
		vo.setParams(request);
		// R}h̏
		if (cmd.equals(CMD_YUKYU_PERSONAL_SHOW)) {
			// \
			show(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * LxǗ
	 * @param vo YukyuPersonalCardVoCX^X
	 * @throws Exception
	 */
	private void show(PaidHolidayCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		vo.setDefaultValues();
		// [U[擾  ЈR[hێ
		getInfo(user.getUserId());
		// I̐ݒ
		// DAO
		MYukyuDao dao = new MYukyuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		//Ώ۔N擾
		Date calcPayment = getCalcPayment();
		// Ώ۔N̑O̗L擾
		// Ώ۔N̏FEF쐬
		makeApprovalYukyuNumber(vo, calcPayment);
		// Ώ۔N̒ǉEp\쐬
		makeAddAndDispose(mKihon.getKCode(), vo, util.addMonth(calcPayment , -1), calcPayment);
		// p\\萔vZ
		/*						
		 *  	2008/11/07	m.yoshida	ɌvZĂ邽߁B
		 */
		//setPaidHolidayCalc(vo);
		// Lx̃`FbN
		// VOɏݒ
		vo.setLblAttendanceCalcY(String.valueOf(MospUtility.getYear(calcPayment)));
		vo.setLblAttendanceCalcM(String.valueOf(MospUtility.getMonth(calcPayment)));
	}

	/**
	 * LxFEF쐬
	 * @param vo
	 * @param targetDate
	 * @throws Exception
	 */
	private void makeApprovalYukyuNumber(PaidHolidayCardVo vo, Date targetDate) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// ΑӏWvΏی̏oΕ̎擾
		getAttendanceList(mKihon.getKCode(), targetDate);
		// oΕWvf[^擾
		//getAttendanceDaily();
		// Αӏݒ
		setCalcParam();
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		double number[] = {0.0, 0.0};
		// oΕWvf[^
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		while (it.hasNext()) {
			// tݒ
			cal.setTime(MospUtility.getDate(startDate));
			MSyukkinboDto dto = it.next();
			Date attendanceDate = MospUtility.getDate(dto.getHizuke());
			// f[^JԂ
			for (int i = 0; i < count; i++) {
				if (attendanceDate.compareTo(cal.getTime()) == 0) {
					// Lxx
					if (isHoliday(dto)) {
						if (dto.getKKRiyuu().equals(aryHolidayReason[0][0])) {
							// FAF
							if (is2ndApproved(dto)) {
								number[0]++;
							} else {
								number[1]++;
							}
						}
					}
					// x
					else if (isQuitHalfHoliday(dto) || isQuitHalfHoliday(dto)) {
						// FAF
						if (is2ndApproved(dto)) {
							number[0] += 0.5;
						} else {
							number[1] += 0.5;
						}
					}
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);			
			}
		}
		// VOɏݒ
		vo.setLblApproved(String.valueOf(number[0]));
		vo.setLblRemainApproved(String.valueOf(number[1]));
	}

	/**
	 * LxǉEp쐬
	 * @param kCode				
	 * @param vo				
	 * @param formerCalcPayment	
	 * @param calcPayment		
	 * @throws Exception
	 */
	private void makeAddAndDispose(
			String kCode,
			PaidHolidayCardVo vo,
			Date formerCalcPayment,
			Date calcPayment
	) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// Jz
		int CFMonth = Integer.parseInt(getPaidHolidayInfo()[0]);
		// Jz
		int CFDays = Integer.parseInt(getPaidHolidayInfo()[1]);
		// Jz敪
		String CFFlag = getPaidHolidayInfo()[2];
		// p[^̏
		// ciNxj
		double remainLastThis = 0;
		// ciONxj
		double remainLastPrev = 0;
		// gp
		double use = 0;
		// x
		int payment = 0;
		// j
		double waste = 0;
		// Lx\萔iNxj
		double remainThisThis = 0;
		// Lx\萔iONxj
		double remainThisPrev = 0;	
		// DAȌ
		MKintaiDao 	mKintaiDao 	= new MKintaiDao();
		MYukyuDao 	mYukyuDao 	= new MYukyuDao();
		mKintaiDao.initDao(cfg, cmd, aspUser, user, conn);
		mYukyuDao.initDao(cfg, cmd, aspUser, user, conn);
		// ̗L񌟍
		String Date = util.convDateToString(calcPayment);
		MYukyuDto currentDto = mYukyuDao.findForKey(kCode, Date);
		if (!chkExistDto(currentDto)) {
			currentDto = new MYukyuDto();
			currentDto.setKCode(kCode);
			currentDto.setKyuyoYMD(Integer.parseInt(Date));
		}
		String formerDate  = util.convDateToString(formerCalcPayment);
		MYukyuDto formerDto = mYukyuDao.findForFormer(kCode, formerDate);
		if (!chkExistDto(formerDto)) {
			formerDto = new MYukyuDto();
		}
		/*						
		 *  	2008/11/07	m.yoshida	gpݒ肵ĂȂ߁B
		 */
		// FϗLxgpɃZbgB
		use = vo.getDoubleParam(vo.getLblApproved());
		// O̗L̐ݒ
		remainLastThis = formerDto.getTZanT();
		remainLastPrev = formerDto.getTZanZ();
		if (CFMonth == MospUtility.getMonth(calcPayment)) {
			// Jz敪
			// N̂
			if (CFFlag.equals(CommonConst.NAM_COMMON_FLAG_OFF)) {
				// pXV
				// OXNxjB
				if (remainLastPrev < use) {
					use = Math.abs(remainLastPrev - use);
					waste = 0;
				} else {
					waste = remainLastPrev - use;
					use = 0;
				}
				// OONx𓖌ONxɈړB
				remainThisPrev = remainLastThis;
			}
			// vŌJz
			else if (CFFlag.equals(CommonConst.NAM_COMMON_FLAG_ON)) {
				// OvČJzJzB
				if ((remainLastPrev + remainLastThis) >= CFDays) {
					waste = (remainLastPrev + remainLastThis) - CFDays;
				} else {
					waste = 0;
				}
				remainThisPrev = remainLastPrev + remainLastThis - waste;
			}
			// Α擾
			double yearOfService = getYearsOfService(kCode);
			// ΑLx擾
			String[][] aryPaidHolidayDays = getPaidHolidayArray();
			for (int i = 0; i < aryPaidHolidayDays.length; i++) {
				if (yearOfService >= Integer.parseInt(aryPaidHolidayDays[i][0])) {
					payment = Integer.parseInt(aryPaidHolidayDays[i][1]);
				}
			}
			remainThisThis += payment;
			//LXV
			if (use <= remainThisPrev) {
				remainThisPrev -= use;
			} else {
				// 
				use -= remainThisPrev;
				remainThisPrev = 0;
				remainThisThis -= use;
			}				
		} else {
			//L擾XV
			remainThisThis += remainLastThis;
			remainThisPrev += remainLastPrev;
			//LXV
			if (use <= remainThisPrev) {
				remainThisPrev -= use;
			} else {
				// 
				use -= remainThisPrev;
				remainThisPrev = 0;
				remainThisThis -= use;
			}
		}
		// VOɏݒ
		vo.setLblThisMGet(String.valueOf(payment));
		vo.setLblThisMDispose(String.valueOf(waste));
		vo.setLblThisMRestLY(String.valueOf(remainThisPrev));
		vo.setLblThisMRestTY(String.valueOf(remainThisThis));
		vo.setLblPaidHolidayLY(String.valueOf(remainLastPrev));
		vo.setLblPaidHolidayTY(String.valueOf(remainLastThis));
	}

	/**
	 * p\\萔vZ
	 * @param vo
	 * @throws Exception
	 */
	/*						
	 *  	2008/11/07	m.yoshida	ɌvZĂ邽߁B
	 */
	/*	private void setPaidHolidayCalc(PaidHolidayCardVo vo) throws Exception {
		double remainThisPrev = Double.parseDouble(vo.getLblThisMRestLY()) 
		- Double.parseDouble(vo.getLblApproved()) 
		- Double.parseDouble(vo.getLblRemainApproved());		
		if(remainThisPrev < 0){			
			vo.setLblThisMRestLY(CommonConst.NAM_COMMON_DOUBLE_INITIAL_VALUE);	
			Double remainThisThis = Double.parseDouble(vo.getLblThisMRestTY()) - remainThisPrev;
			vo.setLblThisMRestTY(String.valueOf(remainThisThis));				
		} else {
			vo.setLblThisMRestLY(String.valueOf(remainThisPrev));					
		}
	}
	 */
}
